/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logoff;

import com.ibm.hwmca.base.logoff.LogoffErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpSession;

public class LogoffApp
extends PresentationTask
implements LogoffErrorIds,
PmDataBean,
ModelActionListener {
    private static final String TASKLET_NAME = "com.ibm.hwmca.base.logoff.LogoffTasklet";
    private static final String TRACE_MASKT = "XLOGOFCT";
    private static final String TRACE_MASKF = "XLOGOFCF";
    private static final String TRACE_MASKD = "XLOGOFCD";
    private static final String TEXT_KEY = "ACTTSK01.TEXT";
    private static final String TITLE_KEY = "ACTTSK01.TITLE";
    private static final int YES = 1;
    private static final int NO = 2;
    private static final int OK = 1;
    private static final int CANCEL = 2;
    private int answer;
    private static final int UNDECIDED = 0;
    private static final int LOGOFF = 1;
    private static final int DISCONNECT = 2;
    private int operation;
    private boolean mainuiclosed;
    private boolean releaseEventThread;
    private int runningTasksCount;

    public LogoffApp(PresentationTaskParms parms) {
        super(parms);
    }

    protected Object runTask() throws Exception {
        Trace.trace(TRACE_MASKF, "-> LogoffApp.runTask()");
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            this.executeForHTML();
        } else {
            this.executeForAUIML();
        }
        Trace.trace(TRACE_MASKF, "<- LogoffApp.runTask()");
        return null;
    }

    private void executeForAUIML() throws Exception {
        PresentationTask[] activeTasks = TaskLauncher.getActiveTasks();
        if (activeTasks.length > 1) {
            Trace.trace(TRACE_MASKF, "   there is at least one active task, logoff is not allowed");
            TaskLauncher.dumpActiveTasks();
            BaseMessageText text = new BaseMessageText(TEXT_KEY);
            BaseMessageTitle title = new BaseMessageTitle(TITLE_KEY);
            CommonMsgApp.showMessageBox(null, title, text);
        } else {
            Trace.trace(TRACE_MASKF, "   there are no active tasks, logoff is allowed");
            Client client = new Client(TASKLET_NAME, "logoff");
            client.init();
            client.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeForHTML() throws Exception {
        try {
            int answer;
            PanelModel panel;
            boolean showedPanel = false;
            HMCSession hmcSession = this.getHMCSession();
            String command = (String)this.getParms().getData("command");
            if (command != null && command.equalsIgnoreCase("logoff")) {
                this.operation = 1;
            } else if (command != null && command.equalsIgnoreCase("disconnect")) {
                this.operation = 2;
            }
            String mode = (String)this.getParms().getData("mode");
            boolean bl = this.mainuiclosed = mode != null && mode.equalsIgnoreCase("mainwindowclosed");
            if (this.mainuiclosed) {
                PanelModelTaskPortal portal = this.getPanelModelTaskPortal();
                portal.setWindowName("mainlogoff_" + (String)this.getParms().getData("windowname"));
                portal.setRefreshEnabled(false);
                portal.setRedirectURL(ServletRuntime.getRuntime().getHMCContextPath() + "/connect?option=closeWindow");
            }
            if (this.operation == 0) {
                this.operation = 1;
                panel = new PanelModel("com.ibm.hwmca.base.logoff.res.choice", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                panel.addModelActionListener(this);
                panel.render();
                showedPanel = true;
                while (true) {
                    if ((answer = this.waitForAction()) == 2) {
                        panel.dispose();
                        return;
                    }
                    if (this.operation != 0) break;
                    this.releaseEventThread();
                }
                panel.dispose();
            }
            if (this.operation == 1 && (this.runningTasksCount = hmcSession.getRunningTasks().size() - 1) > 0) {
                panel = new PanelModel("com.ibm.hwmca.base.logoff.res.killtasks", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                panel.addModelActionListener(this);
                panel.render();
                this.releaseEventThread();
                showedPanel = true;
                answer = this.waitForAction();
                panel.dispose();
                if (answer == 2) {
                    return;
                }
            }
            if (!showedPanel) {
                panel = new PanelModel("com.ibm.hwmca.base.logoff.res.confirm", "com.ibm.hwmca.base.logoff.res.logoff", this, hmcSession.getUserContext().getLocales());
                panel.addModelActionListener(this);
                panel.render();
                answer = this.waitForAction();
                panel.dispose();
                if (answer == 2) {
                    return;
                }
            }
            Trace.trace(TRACE_MASKT, (this.operation == 1 ? "Logging off" : "Disconnecting") + " user \"" + hmcSession.getUserContext().getUserName() + "\" from HMC session \"" + hmcSession.getSessionId() + "\".");
            HttpSession httpSession = hmcSession.getHttpSession();
            if (this.operation == 1) {
                hmcSession.disconnectFromWebSession(7);
                hmcSession.destroy();
            } else {
                hmcSession.disconnectFromWebSession(1);
            }
            httpSession.invalidate();
            if (this.mainuiclosed) {
                this.getPanelModelTaskPortal().setRedirectURL(null);
            }
            Client client = null;
            try {
                client = new Client(TASKLET_NAME, this.operation == 1 ? "logoff" : "disconnect");
                client.init();
            }
            finally {
                if (client != null) {
                    client.terminate();
                }
            }
        }
        finally {
            this.releaseEventThread();
        }
    }

    private synchronized int waitForAction() {
        while (this.answer == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        int result = this.answer;
        this.answer = 0;
        return result;
    }

    private synchronized void setAction(int answer) {
        this.answer = answer;
        this.notifyAll();
    }

    public void actionPerformed(ModelActionEvent event) {
        this.prepareToHandleEvent();
        String command = event.getActionCommand();
        if (command.equals("yes")) {
            this.setAction(1);
        } else if (command.equals("no")) {
            this.setAction(2);
        } else if (command.equals("ok")) {
            this.setAction(1);
        } else if (command.equals("cancel")) {
            this.setAction(2);
        }
        this.waitForEventRelease();
    }

    private synchronized void prepareToHandleEvent() {
        this.releaseEventThread = false;
    }

    private synchronized void releaseEventThread() {
        this.releaseEventThread = true;
        this.notifyAll();
    }

    private synchronized void waitForEventRelease() {
        while (!this.releaseEventThread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(LogoffErrorIds.classLogInfo, 352, throwable).log();
    }

    protected void forceTermination(String reason) {
        this.setAction(2);
    }

    public void setLogoff(boolean loggingOff) {
        if (loggingOff) {
            this.operation = 1;
        } else if (this.operation == 1) {
            this.operation = 0;
        }
    }

    public boolean getLogoff() {
        return this.operation == 1;
    }

    public void setDisconnect(boolean disconnecting) {
        if (disconnecting) {
            this.operation = 2;
        } else if (this.operation == 2) {
            this.operation = 0;
        }
    }

    public boolean getDisconnect() {
        return this.operation == 2;
    }

    public int getRunningTasksCount() {
        return this.runningTasksCount;
    }

    public boolean isMainUIWindowClosed() {
        return this.mainuiclosed;
    }

    public Collection getWindowNames() {
        Trace.trace(TRACE_MASKF, "LogoffApp().getWindowNames()");
        ArrayList<String> windowNames = new ArrayList<String>();
        PanelModelTaskPortal me = this.getPanelModelTaskPortal();
        Iterator iterator = this.getHMCSession().getKnownTasks().iterator();
        while (iterator.hasNext()) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
            if (portal == me || !portal.isWindowOpen()) continue;
            windowNames.add(portal.getWindowName());
            portal.setWindowOpen(false);
        }
        Trace.trace(TRACE_MASKF, "Asking the first panel to close " + windowNames.size() + " task windows:");
        iterator = windowNames.iterator();
        while (iterator.hasNext()) {
            Trace.trace(TRACE_MASKF, " window \"" + iterator.next() + '\"');
        }
        return windowNames;
    }
}

